/*
 * Diese Datei ist Teil des GDialog Projektes:
 * "Gigaset-Erweiterung fr ProjectX"
 * 
 * Das GDialog Projekt ist freigegeben unter
 * der GNU Public Licence (GPL), deren Text sich in
 * dem Quellen-Verzeichnis befindet. Ist er dort nicht
 * mehr vorhanden, so kann er unter http://www.gnu.org/licenses/gpl.html
 * eingesehen werden.
 */
package de.m740.projectx.gigaset;

import java.util.ArrayList;
import java.util.List;

/**
 * GAufnahmeContainer
 * 
 * @author Arno
 * @version $Id: GAufnahmeContainer.java,v 1.1 2006/12/17 13:15:37 java Exp $
 */
public class GAufnahmeContainer {

    private GAufnahmeIF aAufnahme = null;
    
    private List aChildren = null;
    
    private List aDoubles = null;
    
    private boolean aExpandedDouble = false;
    
    public GAufnahmeContainer(GAufnahmeIF inpAufnahme) {
        super();
        setAufnahme(inpAufnahme);
    }

    /**
     * 
     * @return GAufnahmeIF
     */
    public GAufnahmeIF getAufnahme() {
        return aAufnahme;
    }

    public boolean isLocalFile() {
        return (aAufnahme instanceof GAufnahmeLocal);
    }

    public boolean isFTPFile() {
        return (aAufnahme instanceof GAufnahmeFTP);
    }
    
    public boolean hasChildren() {
        return aChildren != null && aChildren.size() > 0;
    }

    public int anzChildren() {
        return (aChildren == null) ? 0 : aChildren.size();
    }

    /*
     * (Kein Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    public String toString() {
        if (aAufnahme != null) {
            return aAufnahme.toString();
        }
        return super.toString();
    }

    /**
     * @param inpAufnahme
     *            Festzulegender aufnahme
     */
    private void setAufnahme(GAufnahmeIF inpAufnahme) {
        aAufnahme = inpAufnahme;
    }

    /**
     * @return doubleList
     */
    public List getChildren() {
        if (aChildren == null) {
            aChildren = new ArrayList();
        }
        return aChildren;
    }

    public void addChild(GAufnahmeIF inpAufnahme) {
        getChildren().add(inpAufnahme);
    }
    
    /**
     * 
     *  number children from old to newer
     */
    public void countChildren(int selector) {
        List tmpChildren = getChildren();
        int anz = anzChildren();
        if (selector != GPanelTableIF.SORT_FILES_ON) {
            return; // not implemented
        }
        int nr = 1;
        for (int i = anz - 1; i >= 0; i--, nr++) {
            GAufnahmeIF tmpAufnahme = (GAufnahmeIF)tmpChildren.get(i);
            tmpAufnahme.setFolgeNr(nr);
            tmpAufnahme.setSerie(anz > 0);
        } // for i
        aAufnahme.setFolgeNr(nr);
        aAufnahme.setSerie(anz > 0);
    }
    
    public void insertChild(GAufnahmeIF inpAufnahme) {
        if (aAufnahme != null) {
            getChildren().add(0, aAufnahme);
        }
        setAufnahme(inpAufnahme);
    }

    /**
     * @return expanded
     */
    public boolean isExpanded() {
        return aDoubles != null && aDoubles.size() > 0;
    }

    /**
     * @return doubles
     */
    public List getDoubles() {
        if (aDoubles == null) {
            aDoubles = new ArrayList();
        }
        return aDoubles;
    }

    public void addDouble(GAufnahmeContainer inpContainer) {
        getDoubles().add(inpContainer);
        inpContainer.setExpandedDouble(true);
    }
    
    public void removeDouble(GAufnahmeContainer inpContainer) {
        getDoubles().remove(inpContainer);
    }

    /**
     * @return expandedDouble
     */
    public boolean isExpandedDouble() {
        return aExpandedDouble;
    }

    /**
     * @param inpExpandedDouble Festzulegender expandedDouble
     */
    public void setExpandedDouble(boolean inpExpandedDouble) {
        aExpandedDouble = inpExpandedDouble;
    }
    
}
